unit EnumObjectFamily;

interface
uses SysUtils, Variants, Classes, Controls, TypInfo, StrUtils;



procedure EnumClassFamily( aClass: TClass; Lines: TStrings );

procedure EnumObjFamily(RgObject : TObject; Lines: TStrings);


implementation


// ===========================================================================
//      ( )
function NormalStr(RqStr : string; NormLen : integer) : string;
begin
  if Length(RqStr) < NormLen
  then Result := RqStr +  DupeString(' ', NormLen - Length(RqStr))
  else Result := RqStr;
end;

// ===========================================================================
//       
procedure RunMethod (pMet, pObj : pointer; Lines: TStrings);
//  TMethod (    )
//    System.   TMRec ,  ,
//    TMethod.
type TMRec  = record
     Code   : pointer;    //     
     Data   : pointer;    //     
end;
type TMet   = procedure of object;

var  MRec   : TMRec;      //  TMRec
     Met    : TMet;       //  TMet,   
begin
    //    
    Lines.Add(Format('  Code : %p  Data : %p', [TMRec(Met).Code, TMRec(Met).Data]));
    //    MRec
    MRec.Code := pMet;
    MRec.Data := pObj;
    //   MRec    
    Met := TMet(MRec);
    //    
    Lines.Add(Format('  Code : %p  Data : %p', [TMRec(Met).Code, TMRec(Met).Data]));
end;

// ===========================================================================
//     
function GetDumpEnd(AClass: TClass): Pointer;
var  Start, Curr, Finish, pEnd : Pointer;
begin
  //      
  pEnd  := Pointer(Integer(aClass) + vmtSelfPtr);
  //    
  Start   := Pointer(Integer(aClass) + vmtIntfTable);
  Finish  := Pointer(Integer(aClass) + vmtClassName);
  //     
  Curr := Start;
  while Integer(Curr) <= Integer(Finish)
  do begin
     if (Integer(Curr^) > Integer(pEnd))
     then begin
        //       
        //      pEnd, 
        //       
        // 
        Integer(pEnd) := Integer(Curr^);
     end;
     //    
     Curr := Pointer(Integer(Curr) + SizeOF(Pointer));
  end;
  Result := pEnd;
end;

// ===========================================================================
//     
function ByteToHexStr (RqByte : byte): string;
const HexCharsArray : array[0..15] of char =
     ('0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F');
begin
 //        
 Result := HexCharsArray[$0F and RqByte];
 //   ,    ,  
 Result := HexCharsArray[($F0 and RqByte) shr 4] + Result;
end;
// =============================================================
//    
function IntToDumpStr (RqDump : pointer) : string;
type Dump = packed record
  B1,B2,B3,B4 : byte;
end;
var pDump : ^Dump;
    HexStr, CharStr : string;
begin
   pDump := RqDump;
   with pDump^ do
   begin
     HexStr  := ByteToHexStr(B1);
     CharStr := Chr(B1);
     HexStr  := HexStr  + ByteToHexStr(B2);
     CharStr := CharStr + Chr(B2);
     HexStr  := HexStr  + ByteToHexStr(B3);
     CharStr := CharStr + Chr(B3);
     HexStr  := HexStr  + ByteToHexStr(B4);
     CharStr := CharStr + Chr(B4);
   end;
   Result := 'Dump : ' + HexStr + ' | ' + CharStr;
end;

// ===========================================================================
//      
procedure ShowTabName (pAddres, PItem  : pointer;
                       Lines: TStrings; TabName : string);
begin
  if (Integer(pAddres^) >= Integer(PItem)) and
     (Integer(pAddres^) <= Integer(PItem) + 3)
  then begin
   Lines.Add(' ');
   if Integer(pAddres^) = Integer(PItem)
   then Lines.Add(Format('%p',[pointer(pAddres^)]) + ' : ' + TabName);
   if Integer(pAddres^) = (Integer(PItem) + 1)
   then Lines.Add(Format('%p',[pointer(pAddres^)]) + ' : ' + TabName);
   if Integer(pAddres^) = (Integer(PItem) + 2)
   then Lines.Add(Format('%p',[pointer(pAddres^)]) + ' : ' + TabName);
   if Integer(pAddres^) = (Integer(PItem) + 3)
   then Lines.Add(Format('%p',[pointer(pAddres^)]) + ' : ' + TabName);
  end;
end;
// ===========================================================================
//    
procedure EnumCPT (aClass: TClass; Lines: TStrings);
//   VTM.     
//     .
type TTabItem = packed record
     pAddress : Pointer;         //  
end;
//    system.pas  Class Pointer Table
const LenNameCPT = 19;
//    system.pas  Class Pointer Table
const NameCPT : array[1..LenNameCPT] of string[17] = (
'SelfPtr',           'IntfTable',         'AutoTable',   'InitTable',
'TypeInfo',          'FieldTable',        'MethodTable', 'DynamicTable',
'ClassName',         'InstanceSize',      'Parent',      'SafeCallException',
'AfterConstruction', 'BeforeDestruction', 'Dispatch',    'DefaultHandler',
'NewInstance',       'FreeInstance',      'Destroy');
//   
var pBeg      : pointer;     //   
    pItem     : ^TTabItem;   //     
    pEnd      : pointer;     //   
    Num       : Word;        //  
    WStr      : string;
begin
  Lines.Add('');
  Lines.Add('   (Class Pointer Table)');
  //      
  pBeg  := Pointer(Integer(aClass) + vmtSelfPtr);
  pItem := pBeg;
  Lines.Add(Format('  Class Pointer Table : %p', [pItem]));
  pEnd := GetDumpEnd(aClass);
  Lines.Add('');
  Lines.Add('    :        ');
  Num := 1;     //    
  repeat
    if Num <= LenNameCPT
    then begin  //    
       with pItem^ do
       Lines.Add(Format('   %p^ : %p    %d. %s',
                       [ pItem, pAddress, Num, NameCPT[Num] ]));
    end
    else begin  //     
       //    
       if Num = (LenNameCPT + 1)
       then begin
          Lines.Add(' ');
          Lines.Add(Format('%p :', [pItem]) + '  Virtual ');
       end;

       ShowTabName(Pointer(Integer(aClass) + vmtIntfTable),
                   pItem, Lines, '  IntfTable');

       ShowTabName(Pointer(Integer(aClass) + vmtAutoTable),
                   pItem, Lines, '  AutoTable');

       ShowTabName(Pointer(Integer(aClass) + vmtInitTable),
                   pItem, Lines, '  InitTable');

       ShowTabName(Pointer(Integer(aClass) + vmtTypeInfo),
                   pItem, Lines, '  TypeInfo');

       ShowTabName(Pointer(Integer(aClass) + vmtFieldTable),
                   pItem, Lines, '  FieldTable');

       ShowTabName(Pointer(Integer(aClass) + vmtMethodTable),
                   pItem, Lines, '  Published ');

       ShowTabName(Pointer(Integer(aClass) + vmtDynamicTable),
                   pItem, Lines, '  Dynamic ');

       ShowTabName(Pointer(Integer(aClass) + vmtClassName),
                   pItem, Lines, '  ClassName');

       //    
       with pItem^ do
       WStr := Format('   %p^ : %p    %d.', [pItem,  pAddress, Num]);
       //   
       WStr := WStr + '  ' + IntToDumpStr(pItem);
       Lines.Add(WStr);
    end;
    Inc(Num);
    //      
    pItem := Pointer(Integer(pItem) + SizeOF(Pointer));
    //         
    until (Integer(pItem) > Integer(pEnd) + 32) or (Num > 1024);
end;

// ===========================================================================
//   
// ===========================================================================
//         (Virtual Method Table)
procedure EnumVirtualMethod (pVMT : pointer; Lines: TStrings);
var pBeg, pEnd, pW1, pW2 : pointer;
    WStr1, WStr2 : string;
    Num : integer;
begin
   //     Virtual Method Table
   pBeg   := pointer(integer(pVMT) + vmtSelfPtr);
   //      vmtIntfTable .. vmtClassName
   pW1    := pointer(integer(pVMT) + vmtIntfTable);
   pEnd   := pointer(integer(pVMT) + vmtClassName);
   pW2    := nil;
   //       
   //     
   while integer(pW1) <= integer(pEnd)
   do begin
     //     
     if (pW2 = nil) and (pointer(pW1^) <> nil) then pW2 := pointer(pW1^);
     //         
     if (pointer(pW1^) <> nil) and (pW2 <> nil) and
        (integer(pointer(pW1^)) <= integer(pW2)) then pW2 := pointer(pW1^);
     //      Class Pointer Table
     pW1 := pointer(integer(pW1) + SizeOF(pointer));
   end;
   Lines.Add('');
   //   pW2   pBeg   
   //    
   if (integer(pW2) > integer(pointer(pBeg^)))
   then begin
      Num := 1;
      pW1 := pointer(pBeg^);
      Lines.Add('  VIRTUAL  : ' + Format('%p', [pW1]));
      Lines.Add('        ');
      while integer(pW1) < integer(pW2)
      do begin
          WStr1 := TClass(pVMT).MethodName(pointer(pW1^));
          WStr2 := Format('%p^ : %p', [pW1, pointer(pW1^)]);
          if WStr1 <> ''
          then WStr2 := WStr2 + '  Name : ' + WStr1
          else WStr2 := WStr2 + '  UnPublished';
          Lines.Add(NormalStr(IntToStr(Num) + '.', 4) + WStr2);

          //  
          RunMethod (pointer(pW1^), pointer($000000ff), Lines);

         //    
         pW1 := pointer(integer(pW1) + SizeOF(pointer));
         Num := Num + 1;
      end;
   end
   else Lines.Add('  VIRTUAL  : 00000000');
end;

// ===========================================================================
//       Dynamic 
procedure EnumDynamicMethod (aClass: TClass; Lines: TStrings);
//  Dynamic    
type TDyna1Item = packed record
         IInd   : SmallInt;     //  
end;
//  Dynamic      
type TDyna2Item = packed record
      pAddress  : Pointer;      //    
end;
var pBegDYNA     : pointer;     //    
    NumItems     : Word;        //    
    pDyna1Item   : ^TDyna1Item; //     
    pDyna2Item   : ^TDyna2Item; //     
    Num          : Word;        //    
    p            : pointer;     //  
    pp           : ^Pointer;    //    
    WStr1, WStr2 : string;
begin
  Lines.Add('');
  //      Dynamic 
  pp := Pointer(Integer(aClass) + vmtDynamicTable);  pBegDYNA := pp^;
  Lines.Add(Format('  DYNAMIC  : %p', [pBegDYNA]));
  if pBegDYNA <> nil then
  begin
     Lines.Add('    ');
     //   (word)       
     NumItems := PWord(pBegDYNA)^;
     Lines.Add(Format('   Dynamic  :  %d', [NumItems]));
     Lines.Add('    Dynamic  :');
     //   (pDyna1Item)     , 
     //      (2 )   Dynamic .
     pDyna1Item := Pointer(Integer(pBegDYNA) + SizeOF(Word));
     for Num := 1 to NumItems do
     begin
       with pDyna1Item^ do
            Lines.Add(format( '  %d. Index : %d', [Num,  IInd]));
       //   (pMetItem)     
       pDyna1Item := Pointer(Integer(pDyna1Item) + SizeOF(pDyna1Item^.IInd));
     end;
     Lines.Add('    Dynamic  :');
     p := pDyna1Item;  pDyna2Item := p;
     for Num := 1 to NumItems do
     begin
       with pDyna2Item^
       do begin
          WStr1 := aClass.MethodName(pAddress);
          WStr2 := Format( '  %d. Addr : %p', [Num,  pAddress]);
          if WStr1 <> ''
          then WStr2 := WStr2 + '  Name : ' + WStr1
          else WStr2 := WStr2 + '  UnPublished';
          Lines.Add(WStr2);
       end;
       //   (pMetItem)     
       pDyna2Item := Pointer(Integer(pDyna2Item) + SizeOF(Pointer));
     end;
  end;
end;

// ===========================================================================
//       Published 
procedure EnumPublishedMethod (aClass: TClass; Lines: TStrings);
//  Published 
type TMetItem = packed record
     ILen     : Word;          //     
     pAddress : Pointer;       //   
     MName    : ShortString;   //  
end;
var pBegVTM   : pointer;       //    
    NumItems  : Word;          //    
    pMetItem  : ^TMetItem;     //      
    Num       : Word;          //  
    pp        : ^pointer;      //    

begin
  Lines.Add('');
  pp := Pointer(Integer(aClass) + vmtMethodtable);  pBegVTM := pp^;
  Lines.Add(Format('  Published  : %p', [pBegVTM]));
  if pBegVTM <> nil then
  begin
     Lines.Add('   Published ');
     //   (word)       
     NumItems := PWord(pBegVTM)^;
     Lines.Add(Format('   published  : %d', [NumItems]));

     //   (pMetItem)     , 
     //      (2 )    (MetTab).
     pMetItem := Pointer(Integer(pBegVTM) + 2);
     for Num := 1 to NumItems do
     begin
       with pMetItem^ do
            Lines.Add(format( '  %d. Len : %d ; Addr : %p ; Name : %s',
                               [Num,  ILen,      pAddress,   MName]));
       //   (pMetItem)    
       pMetItem := Pointer(Integer(pMetItem) + pMetItem^.ILen);
     end;
  end;
end;

// ===========================================================================
//    
// ===========================================================================
//    
procedure ShowClassProrerty (PListProp : PPropList;
                             PropCount : Integer;
                             Lines     : TStrings);
var   Ind          : integer;
      WStr1, WStr2  : string;
      ATypeData    : PTypeData;  //     
begin
  //      
  if Assigned(PListProp) and (PropCount > 0)
  then begin
     Lines.Add(' Published :');
     //  
     for Ind := 0 to PropCount - 1 do
     begin
        //  
        WStr1 := NormalStr(IntToStr(Ind + 1) + '. ', 4);
        //   
        WStr2 := NormalStr(GetEnumName(TypeInfo(TTypeKind),
                           Integer(PListProp^[Ind].PropType^.Kind)), 16);
        WStr1 := WStr1 + WStr2;
        //    
        WStr2 := NormalStr(PListProp^[Ind].Name, 16);
        WStr1 := WStr1 + ' Name : ' + WStr2;
        //    
        WStr2 := NormalStr(PListProp^[Ind].PropType^.Name, 16);
        WStr1 := WStr1 + ' Type : ' + WStr2;
        //     ,    Unit  
        //       
        ATypeData  := GetTypeData(PListProp^[Ind].PropType^);
        if Assigned (ATypeData)
        then begin
          //   Unit
          if (PListProp^[Ind].PropType^.Kind = tkClass)
          then WStr1 := WStr1 + #09 + 'Unit : ' +  ATypeData^.UnitName;
        end;
        Lines.Add(WStr1)
     end;
  end;
end;
// ===========================================================================
//       
procedure EnumClassProrerty(RqClass  : TClass;
                            Lines: TStrings);
var
  ATypeInfo  : PTypeInfo;  //   
  ATypeData  : PTypeData;  //     
  PropCount  : Integer;    //  
  PListProp  : PPropList;  //   

begin
  //        
  ATypeInfo  := PTypeInfo(RqClass.ClassInfo);
  if Assigned(ATypeInfo)
  then begin
     ATypeData  := GetTypeData(ATypeInfo);
     if Assigned (ATypeData)
     then begin
       //     
       PropCount  := ATypeData^.PropCount;
       //  
       Lines.Add('');
       Lines.Add( 'Unit : '
                 + ATypeData^.UnitName
                 + ',  : ' + RqClass.ClassName
                 + ',   : '
                 + IntToStr(PropCount));
       if PropCount > 0 then
       begin
          GetMem(PListProp, PropCount * SizeOf(Pointer));
          //    
          GetPropInfos(ATypeInfo, PListProp);
          //   
          ShowClassProrerty(PListProp, PropCount, Lines);
          FreeMem(PListProp, PropCount * SizeOf(Pointer));
       end;
     end;
  end
  else Lines.Add(' ' + RqClass.ClassName
               + ' :  ');
end;

// ===========================================================================
//    
// ===========================================================================
procedure EnumClassFamily(aClass: TClass; Lines: TStrings);
begin
  if aClass = nil then Exit; //  
     // *********
     Lines.Add('');
     if aClass.ClassParent <> nil
     then begin
       Lines.Add('==========================================');
       Lines.Add(Format('%s = class ( %s )',
                        [aClass.Classname, aClass.ClassParent.ClassName]));
     end
     else begin
       Lines.Add('==========================================');
       Lines.Add(Format('%s = class ()', [aClass.Classname]));
     end;
     Lines.Add('------------------------------------------');
     //  Published  
     EnumClassProrerty(aClass, Lines);
     //   Published methods
     EnumPublishedMethod (aClass, Lines);
     //   Virtual methods
     EnumVirtualMethod (aClass, Lines);
     //   Dynamic methods
     EnumDynamicMethod (aClass, Lines);
     //   
     EnumCPT (aClass, Lines);
     Lines.Add('');
  //  *********
  //      
  EnumClassFamily(aClass.ClassParent,Lines );
end;

// ===========================================================================
//  VMT  
procedure EnumObjFamily(RgObject : TObject; Lines: TStrings);
var aClass : TClass;
    pp     : ^pointer;               //    
begin
    pp := pointer(RgObject);         //    VMT  
    aClass := TClass(pp^);           //     TClass
    EnumClassFamily(aClass, Lines);  //    
end;

end.
